<?php
/**
 * The template for displaying Search Results pages.
 *
 * @package _tk
 */

get_header(); ?>

<div class="container">
	<div class="row">
		<div class="col-sm-18 col-sm-push-6">
			<?php if ( have_posts() ) : ?>
		
				<header>
					<h2 class="page-title"><?php printf( __( 'Search Results for: %s', '_tk' ), '<span>' . get_search_query() . '</span>' ); ?></h2>
				</header><!-- .page-header -->

				<?php // start the loop. ?>
				<?php while ( have_posts() ) : the_post(); ?>

					<?php get_template_part( 'elements/content', 'search' ); ?>

				<?php endwhile; ?>

				<?php _tk_pagination(); ?>

			<?php else : ?>

				<?php get_template_part( 'no-results', 'search' ); ?>

			<?php endif; // end of loop. ?>
		</div>
		<div class="col-sm-6 col-sm-pull-18 shop-sidebar">
			<?php get_sidebar('shop'); ?>
		</div>
	</div>
</div>
<?php get_footer(); ?>